IF  EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[PG_CRED_POSICAO_FINANCEIRA_PROCESSAR]') 
					AND type in (N'U')) 
begin
	DROP TABLE PG_CRED_POSICAO_FINANCEIRA_PROCESSAR
end

CREATE TABLE [dbo].[PG_CRED_POSICAO_FINANCEIRA_PROCESSAR](
	[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[DT_PROC] [datetime] NOT NULL,
	[DT_CAD] [datetime] NULL,
	[ORIGEM] [varchar](150) NULL,
	[DT_ULT_PROC] [datetime] NOT NULL,
 CONSTRAINT [PK_PG_CRED_POSICAO_FINANCEIRA_PROCESSAR_1] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_PG_CRED_POSICAO_FINANCEIRA_PROCESSAR] UNIQUE NONCLUSTERED 
(
	[DT_CAD] ASC,
	[CD_FILIAL] ASC,
	[CD_EMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PG_CRED_POSICAO_FINANCEIRA_PROCESSAR] ADD  CONSTRAINT [DF_PG_CRED_POSICAO_FINANCEIRA_PROCESSAR_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[PG_CRED_POSICAO_FINANCEIRA_PROCESSAR] ADD  CONSTRAINT [DF_PG_CRED_POSICAO_FINANCEIRA_PROCESSAR_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[PG_CRED_POSICAO_FINANCEIRA_PROCESSAR] ADD  CONSTRAINT [DF_PG_CRED_POSICAO_FINANCEIRA_PROCESSAR_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[PG_CRED_POSICAO_FINANCEIRA_PROCESSAR] ADD  CONSTRAINT [DF_PG_CRED_POSICAO_FINANCEIRA_PROCESSAR_ORIGEM]  DEFAULT ('') FOR [ORIGEM]

ALTER TABLE [dbo].[PG_CRED_POSICAO_FINANCEIRA_PROCESSAR] ADD  CONSTRAINT [DF_PG_CRED_POSICAO_FINANCEIRA_PROCESSAR_DT_ULT_PROC]  DEFAULT (getdate()) FOR [DT_ULT_PROC]